<?php
function seg(){
    $uri_path = $_SERVER["REQUEST_URI"];
    $exp = explode("/", $uri_path);
    $seg = end($exp);
    $seg = explode("?", $seg);
    $seg = $seg[0]; 
    return $seg;
}

function base_url($path  = ""){
    $protocol = "http://";
    $port = "";
    if (isset($_SERVER['SERVER_PORT'])){
        $port = ":".$_SERVER['SERVER_PORT'];
    }
    if ( isset($_SERVER['HTTPS']) ){
        if ( $_SERVER['HTTPS'] != 'off' ){
            $protocol = "https://";
        }else{
            $protocol = "http://";
        }
    }
    $url = $protocol.$_SERVER['SERVER_NAME'].$port;
    $url = stripslashes($url);
    $url = rtrim($url, "/");
    return $url."/".$path;
}
function admin_url($path = ""){
    return base_url(ADMIN."/".$path);
}
function refirect($path=""){
    header("location:".base_url(ADMIN."/").$path);
}

function db_insert($table, $data){
    $columns = implode(", ", array_keys($data));
    $values = implode(", ", array_map(function($value) {
        return "'" . addslashes($value) . "'";
    }, array_values($data)));
    $sql = "INSERT INTO $table ($columns) VALUES ($values)";
    $db = connectToDatabase();
    $m = $db->prepare($sql);
    $m->execute();
    return $db->lastInsertId();
}

function db_update($table, $data, $condition){
    $set = implode(", ", array_map(function($key, $value) {
        return "$key = '" . addslashes($value) . "'";
    }, array_keys($data), array_values($data)));
    $sql = "UPDATE $table SET $set WHERE $condition";
    $db = connectToDatabase();
    $m = $db->prepare($sql);
    $m->execute();
    return true;
}

function db_select($sql, $is_rows = false){
    $db = connectToDatabase();
    $m = $db->prepare($sql);
    $m->execute();
    if ($is_rows){
        $u = $m->fetchAll();
    }else{
        $u = $m->fetch();
    }
    return $u;
}

function run_query($sql){
    $db = connectToDatabase();
    $m = $db->prepare($sql);
    $m->execute();
    return true;
}

function set_flash($msg, $type = "success", $key = ""){
    $m = "";
    if ($type=="success"){
        $m = "<div class='alert alert-success'>$msg</div>"; 
    }elseif ($type=="error"){
        $m = "<div class='alert alert-danger'>$msg</div>"; 
    }elseif ($type=="info"){
        $m = "<div class='alert alert-info'>$msg</div>"; 
    }elseif ($type=="warning"){
        $m = "<div class='alert alert-warning'>$msg</div>"; 
    }
    $key = ($key=="") ? "flash" : $key;
    $_SESSION[$key] = $m;
}

function flash($key = "flash"){
    if (isset($_SESSION[$key])){
        $msg = $_SESSION[$key];
        unset($_SESSION[$key]);
        return $msg;
    }
    return "";
}

function view($file = ""){
    ob_start();
    include BASE_PATH."temp/meta.php";
    if (file_exists($file)){
        include $file;
    }
    include BASE_PATH."temp/footer.php";
    $d = ob_get_contents();
    
    return $d;
}
?>